
// MainFrm.cpp: Implementierung der Klasse CMainFrame
//

#include "stdafx.h"
#include "UsccView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#ifndef WM_SETMESSAGESTRING
#define WM_SETMESSAGESTRING 0x0362
#endif

// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
    ON_WM_CREATE()
    ON_WM_SETFOCUS()
    ON_WM_GETMINMAXINFO()
    ON_MESSAGE(WM_SETMESSAGESTRING, OnSetMessageString)
END_MESSAGE_MAP()

static UINT indicators[] =
{
    ID_SEPARATOR,           // Statusleistenanzeige
    ID_INDICATOR_CAPS,
    ID_INDICATOR_NUM,
    ID_INDICATOR_SCRL,
};

// CMainFrame-Erstellung/Zerstrung

CMainFrame::CMainFrame()
{
    // TODO: Hier Code fr die Memberinitialisierung einfgen
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if(CFrameWnd::OnCreate(lpCreateStruct) == -1) {
        return -1;
    }

    // Ansicht erstellen, um den Clientbereich des Rahmens zu belegen
    if(!m_wndView.Create(NULL, NULL, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL)) {

        TRACE0("Fehler beim Erstellen des Ansichtsfensters.\n");
        return -1;
    }

    if(!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
       !m_wndToolBar.LoadToolBar(IDR_MAINFRAME)) {

        TRACE0("Fehler beim Erstellen der Symbolleiste.\n");
        return -1;      // Fehler beim Erstellen
    }

    if(!m_wndStatusBar.Create(this)) {

        TRACE0("Fehler beim Erstellen der Statusleiste.\n");
        return -1;      // Fehler beim Erstellen
    }

    m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT));

    return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
    if(!CFrameWnd::PreCreateWindow(cs)) {
        return FALSE;
    }
    // TODO: ndern Sie hier die Fensterklasse oder die Darstellung, indem Sie
    //  CREATESTRUCT cs modifizieren.

    cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
    cs.lpszClass = AfxRegisterWndClass(0);
    return TRUE;
}

// CMainFrame-Diagnose

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
    CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
    CFrameWnd::Dump(dc);
}
#endif //_DEBUG


// CMainFrame-Meldungshandler

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/)
{
    // Fokus an das Ansichtsfenster weitergeben
    m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
    // Ansichtsfenster erhlt ersten Eindruck vom Befehl
    if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo)) {
        return TRUE;
    }

    // andernfalls die Standardbehandlung durchfhren
    return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
    CFrameWnd::OnGetMinMaxInfo(lpMMI);

    lpMMI->ptMinTrackSize.x = 300;
    lpMMI->ptMinTrackSize.y = 300;
}



LRESULT CMainFrame::OnSetMessageString(WPARAM wParam, LPARAM lParam)
{
    UINT nIDLast = m_nIDLastMessage;
    m_nFlags &= ~WF_NOPOPMSG;

    CWnd* pMessageBar = GetMessageBar();
    if(pMessageBar != NULL) {

        CString sMsg;
        CString strMessage;

        // set the message bar text
        if(lParam != 0) {

            ASSERT(wParam == 0);    // can't have both an ID and a string
            m_strStatusBarIdleString = (LPCTSTR)lParam; // set an explicit string
            sMsg = m_strStatusBarIdleString;
        }
        else if (wParam != 0) {

            // map SC_CLOSE to PREVIEW_CLOSE when in print preview mode
            if (wParam == AFX_IDS_SCCLOSE && m_lpfnCloseProc != NULL) {
                wParam = AFX_IDS_PREVIEW_CLOSE;
            }

            // get message associated with the ID indicated by wParam
            if(wParam == AFX_IDS_IDLEMESSAGE) {
                sMsg = m_strStatusBarIdleString;
            }
            else {

                GetMessageString((UINT)wParam, strMessage);
                sMsg = strMessage;
            }
        }

        pMessageBar->SetWindowText(sMsg);
    }

    m_nIDLastMessage = (UINT)wParam;    // new ID (or 0)
    m_nIDTracking = (UINT)wParam;       // so F1 on toolbar buttons work

    return nIDLast;
}


void CMainFrame::StatusBarIdleMessage(LPCTSTR lpszMessage)
{
    m_strStatusBarIdleString = lpszMessage;

    if(m_strStatusBarIdleString.IsEmpty()) {
        m_strStatusBarIdleString.LoadString(AFX_IDS_IDLEMESSAGE);
    }

    SetMessageText(m_strStatusBarIdleString);
}


CString CMainFrame::UsccOcxInfo()
{
    CString result, strFormat, strText, strRet;
    int nRet;

    if(!IsWindow(m_wndView.m_hWnd)) {
        return result;
    }

    strText = _T("ApiVersion: ");
    nRet = m_wndView.GetApiVersion();
    strFormat.Format(_T("\t%d\r\n"), nRet);
    result = strText + strFormat;

    strText = _T("BuildDate: ");
    strRet = m_wndView.GetBuildDate();
    strFormat.Format(_T("\t%s\r\n"), strRet);
    result += strText + strFormat;

    strText = _T("BuildNumber: ");
    nRet = m_wndView.GetBuildNumber();
    strFormat.Format(_T("\t%d\r\n"), nRet);
    result += strText + strFormat;

    strText = _T("Version: ");
    strRet = m_wndView.GetVersion();
    strFormat.Format(_T("\t\t%s\r\n"), strRet);
    result += strText + strFormat;

    return result;
}


BOOL CMainFrame::CanCloseApp()
{
    int nRet = AfxMessageBox(IDS_EXIT_APP, MB_YESNO|MB_ICONQUESTION);

    if(nRet == IDNO) {
        return FALSE;
    }

    m_wndView.EnableActiveX(0);

    return TRUE;
}
